from quart import Quart, render_template, redirect, url_for, request, flash

from supabase import acreate_client, AsyncClient, AuthApiError, AuthWeakPasswordError
import asyncpg

from os import environ
from dotenv import load_dotenv

from pprint import pprint


load_dotenv()

app = Quart(__name__)
app.secret_key = b'ab_xu-32a.py'

db: asyncpg.Connection
sb: AsyncClient


@app.before_serving
async def initialize():
    global sb, db
    db = await asyncpg.connect(database="postgres", user="postgres.iuigaymmmsvvcffbbrzj", password=environ['DB_PASS'], host="aws-1-us-east-2.pooler.supabase.com", port=5432)
    sb = await acreate_client(f"https://{environ.get('DB_URL')}", environ.get("SB_KEY"))

@app.after_serving
async def wrap_up():
    await db.close()

@app.route("/")
async def index():
    user = None

    if (token:=request.args.get("access_token")) and (refresh_token:=request.args.get("refresh_token")):
        pprint(token)
        pprint(refresh_token)
        response = await sb.auth.set_session(token, refresh_token)
        user = response.user if response else user
    else:
        response = await sb.auth.get_user()
        user = response.user if response else user
    pprint(response)
    if not response:
        return await render_template("landing.html")
    user = response.user
    return await render_template("index.html", username=user.email)

@app.route("/login/", methods=["GET", "POST"])
async def login():
    response = await sb.auth.get_user()
    pprint(response)
    if response:
        return redirect(url_for('index'))
    if request.method == "POST":
        formData = await request.form
        email = formData.get("email")
        passwd = formData.get("password")

        try: 
            response = await sb.auth.sign_in_with_password({"email": email, "password": passwd})
        except AuthApiError:
            await flash("Invalid Credentials. Please Check Your Email Password and Try Again.")
        else:
            pprint(response)
            return redirect(url_for('index'))

    return await render_template('login.html')

@app.route("/signup/", methods=["GET", "POST"])
async def signup():
    if request.method == "GET":
        account_type = request.args.get("account_type")
        if account_type=="doctor":
            doctor_types = [t.get('type_name') for t in await db.fetch("SELECT * FROM doctor_types;")]
            return await render_template(
                "signup.html", 
                account_type='doctor',
                types=doctor_types
            )
        elif account_type == 'patient':
            return await render_template(
                "signup.html", 
                account_type='patient',
                types=[]
            )
        else:
            return await render_template(
                'select_type.html', 
                account_type='patient', 
                doctor_types=[]
            )
    
    formData = await request.form

    """
    TODO:
        Create account according to the account type.
        save account type in the account-type table
        save blood, gender, major in user-info table
    """
    name = formData.get("name")
    age = int(formData.get("age", 0))
    blood = formData.get("blood")
    gender = formData.get("gender")

    print(name, age, blood, gender)

    email = formData.get("email")
    passwd = formData.get("pass")

    try:
        response = await sb.auth.sign_up({"email": email, "password": passwd})
    except AuthWeakPasswordError:
        await flash("Password is too weak. Include Letters and Numbers in your password.")
        return redirect(url_for('signup'))

    pprint(response)

    if response.user is not None and response.session is None:
        await flash("Account Created Successfully! Use your Credentials to login.")
        return redirect(url_for('confirm_email'))

    return "", 200

@app.route("/signout/")
async def signout():
    await sb.auth.sign_out()
    return redirect(url_for('login'))

@app.route("/confirm_email")
async def confirm_email():
    return await render_template('confirm_email.html')

if __name__ == "__main__":
    app.run(host="0.0.0.0", port=8080, debug=True)